﻿#include  "StdAfx.h"

#include  <szFile.hpp>
#include  <szRuntimeException.hpp>
#include  <buffers.hpp>
#include  <tchar.h>

SZ_NS_BEG(szpp)

SZ_SPEC
bool FileExists(const szstring &path)
{
  DWORD dwAttr = GetFileAttributes(path.c_str());
  if (INVALID_FILE_ATTRIBUTES != dwAttr)
    return 0 == (dwAttr & FILE_ATTRIBUTE_DIRECTORY);
  
  DWORD err = GetLastError();
  if (ERROR_FILE_NOT_FOUND != err && ERROR_PATH_NOT_FOUND != err)
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot get file attributes")) << last_error_info(err));
  
  return false;
}

SZ_SPEC
bool DirectoryExists(const szstring &path)
{
  DWORD dwAttr = GetFileAttributes(path.c_str());
  if (INVALID_FILE_ATTRIBUTES != dwAttr)
    return 0 != (dwAttr & FILE_ATTRIBUTE_DIRECTORY);
  
  DWORD err = GetLastError();
  if (ERROR_FILE_NOT_FOUND != err && ERROR_PATH_NOT_FOUND != err)
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot get file attributes")) << last_error_info(err));
  
  return false;
}

SZ_SPEC
u64 GetFileSize(const szstring &fileName)
{
  WinHandle hFile(CreateFile(fileName.c_str(), GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0));
  if (hFile.Get() == INVALID_HANDLE_VALUE)
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot get file size")) << last_error_info(GetLastError()));

  LARGE_INTEGER li;
  if (0 == GetFileSizeEx(hFile, &li))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot get file size")) << last_error_info(GetLastError()));

  return li.QuadPart;
}

SZ_NS_END(szpp)

